#pragma rtGlobals=1		// Use modern global access method.

Menu "IV/FV"
"IV for ramp"
"IV for step"
"Truncate the ramp FV"
"-"
"Fractional activation analysis"
"IV"
"-"
end


Function/D IVr()

	variable/G gVr

	wave I_avg
	wave V_avg
	curvefit line I_avg[17,22] /X=V_avg  /////////////Change the range of linear part when different IV protocols are applied.///////////////////
	wave W_Coef
	variable b=W_coef[0]
	variable mp=w_coef[1]
	gVr=(mean(I_avg,0,3)-b)/mp
	killwaves W_Coef,W_Sigma
	
	SetDataFolder root:
	
	variable/G Vr=gVr
	
	return gVr

end


function cVr()
	
	wave Vmon=$"CrVmon_Ramp"
	wave Imon=$StringFromList(0,tracenamelist("",";",1))
		
	variable S=pcsr(A)
	variable E=pcsr(B)
//	variable O=pcsr(C)
	
	CurveFit/Q/NTHR=1 line  Imon[pcsr(A),pcsr(B)] /X=Vmon
//	killwaves sImon,sVmon	
	wave W_Coef 
	variable Io=mean(Imon,pnt2x(Imon,50),pnt2x(Imon,500))
	variable/G iVr=(Io-1*W_Coef[0])/W_Coef[1]
	print iVr*1000
	
end

function/D fVr()
	
	wave Vslow=$"Vslow_Spot0"
	wave Ftr=$"Ratio_spot0"
		
	
	CurveFit/Q/NTHR=1 line  Ftr[53,58] /X=Vslow
//	killwaves sImon,sVmon	
	wave W_Coef 
	variable Io=mean(Ftr,pnt2x(Ftr,0),pnt2x(Ftr,37))
	variable/G gVr=(Io-1*W_Coef[0])/W_Coef[1]
	print gVr*1000
	return gVr
	
end

function CopygVr()
	DFREF home=getdatafolderdfr()
	variable/G GenVr
	
	string Fn=ListFolder()
	variable i
	for(i=0;i<=ItemsInList(Fn);i+=1)		
		setdatafolder $stringfromlist(i,Fn)
		variable/G gVr=GenVr
		cPopenF(1)
		setdatafolder home
	endfor


end

function cPopenF(index)
	variable index //0:Vr,1:GenVr
	
	wave/Z w=$"_Avg"
	if(waveexists(w)==1)
		killwaves w
	else
	endif
	
	DFREF home=getdatafolderdfr()
	
	switch(index)
		case 0:
			variable/G iVr
			variable Vr=iVr
			newdatafolder/S FPopen_Vr
			DFREF Target=getdatafolderdfr()
			break
		case 1:
			variable/G gVr
			Vr=gVr
			newdatafolder/S FPopen_gVr
			DFREF Target=getdatafolderdfr()
			break
		case 2:
			variable/G gVr
			if(gVr==0)
				DoAlert 2,"No reversal potential"
				return 0
			endif
			Vr=gVr
			newdatafolder/S FPopen_gVr
			DFREF Target=getdatafolderdfr()			
			break
	endswitch
	setdatafolder home
	
	if(index!=2)
		wave F=$stringfromlist(0,Wavelist("Avg_S",";",""))
		wave V=$"VmonSlow"
		wavestats/Q/R=[1,8] F
		
		variable Frest=V_avg
		variable mp=(Frest-F[28])/(Vr-V[28])
		duplicate/R=[9,28] V, VslowTru
		duplicate/R=[9,28] F, FVTru
		setscale/P x,VSlowTru[0],0.005,FVTru
	
	else
		controlinfo Fwave
		wave F=$S_value
		controlinfo VsloWave
		wave V=$S_value
		
		variable/G St,En,ReSt,ReEn
		wavestats/Q/R=[St,En] F
		
		Frest=V_avg

		if(ReEn>ReSt)
			mp=(Frest-F[ReEn])/(Vr-V[ReEn])
		else
			mp=(Frest-F[ReSt])/(Vr-V[ReSt])
		endif
		duplicate/R=[St,ReEn] V, VslowTru
		duplicate/R=[St,ReEn] F, FVTru
		controlinfo Vstep
		variable Vscale=V_value
		setscale/P x,VSlowTru[0],Vscale,FVTru		
	endif
				
	movewave VslowTru, target
	movewave FVTru,target
	setdatafolder Target
	Duplicate FVTru,Popen
	Popen=Popen-Frest
	Popen=Popen/(Frest-mp*(Vr-VslowTru))
	
	CurveFit/N/NTHR=0 Sigmoid  Popen /X=VslowTru /D
	wave W_Coef,W_sigma
	variable Vhalf=W_Coef[2]
	variable k=W_Coef[3]

	printf "%g,%g\r", Vhalf,k
	
	setdatafolder home
	if(index==2)
		wave fit_FV=RefineFVTrace(FRest,mp,Vhalf,k,St,ReEn,2)
	else
		wave fit_FV=RefineFVTrace(FRest,mp,Vhalf,k,St,ReEn,1)
	endif
	
	Differentiate fit_FV/D=d_fit
	if(index==2)
		setscale/P x,VSlowTru[0],Vscale,FVTru
	else
		setscale/P x,VSlowTru[0],0.005,FVTru
	endif
	variable i=0
	do
		i=i+1
	while(d_fit[i+1]*d_fit[i]>0 && i<dimsize(d_fit,0))
	Variable Px=i+5
	variable/G Xv=pnt2x(d_fit,Px)
	mp=(Fit_FV[Px]-FRest)/(Xv-Vr)
	
	print mp
	
	make/O/n=(DimSize(Fit_FV,0)) Cor_Po
	
	for(i=0;i<DimSize(Fit_FV,0);i+=1)
		Cor_Po[i]=(fit_FV[i]-fit_FV[0])/(mp*(pnt2x(fit_FV,i)-Vr))		
	endfor
	setscale/P x,dimoffset(fit_FV,0),dimdelta(fit_FV,0),Cor_Po
	CurveFit/N/NTHR=0 Sigmoid  Cor_Po /D
	
end

function/Wave GenIniGuess(Pop,V)
	wave Pop,V

	make/O/n=(4,2) inG
	inG[0][0]=0
	inG[1][0]=Pop[DimSize(Pop,0)-1]
	
	variable i=-1
	variable j
	
	do
		i=i+1
	while(Pop[i]<0.5)
	
	if(Pop[i]+Pop[i-1]>1)
		inG[0][2]=V[i-1]		
		j=i-1
	else
		inG[0][2]=V[i]
		j=1
	endif
	
	CurveFit/NTHR=1 line  Popen[j-1,j+1] /X=V /D 
	wave W_Coef
	variable m=W_Coef[1]
	killwaves W_Coef
	
	variable x0=V[j]+(1-Pop[j])/m
	CurveFit/NTHR=1/K={x0} exp_XOffset  Pop[0,j] /X=V /D
	
end


function FVProfile(ind)
	variable ind
	
	DFREF home=getdatafolderdfr()
	string Fn=ListFolder()
	variable i
	
	for(i=0;i<ItemsInList(Fn)-1;i+=1)
		if(waveexists(FvCoef_Vr)==1)
			movewave FvCoef_Vr, :$stringfromlist(i,Fn):Popen_CaVr:
			movewave FvError_Vr, :$stringfromlist(i,Fn):Popen_CaVr:
			setdatafolder $stringfromlist(i,Fn)
		elseif(waveexists(FvCoef_gVr)==1)
			movewave FvCoef_gVr, :$stringfromlist(i,Fn):Popen_gVr:
			movewave FvError_gVr, :$stringfromlist(i,Fn):Popen_gVr:
			setdatafolder $stringfromlist(i,Fn)		
		elseif(waveexists(RefineFV)==1)
			movewave FvCoef_gVr, :$stringfromlist(i,Fn):RefineFv:
			movewave FvError_gVr, :$stringfromlist(i,Fn):RefineFv:
			setdatafolder $stringfromlist(i,Fn)
		else
			setdatafolder $stringfromlist(i,Fn)
		endif
		
		switch(ind)
			case 0:
				setdatafolder FPopen_CaVr
				break
			case 1:
				setdatafolder FPopen_gVr
				break
			case 2:
				setdatafolder RefineFv
				break
		endswitch
		
		wave W_Coef,W_Sigma
		matrixtranspose W_Coef
//		killwaves W_Coef
//		rename M_x,W_coef
		matrixtranspose w_Sigma
//		killwaves W_sigma
//		rename M_x,W_Sigma
		
		switch(ind)
			case 0:
				concatenate/NP=0 {W_Coef}, FvCoef_Vr
				concatenate/NP=0 {W_Sigma}, FvError_Vr
				movewave FvCoef_Vr,home
				movewave FvError_Vr,home
				break
			case 1:
				concatenate/NP=0 {W_Coef}, FvCoef_gVr
				concatenate/NP=0 {W_Sigma}, FvError_gVr
				movewave FvCoef_gVr,home
				movewave FvError_gVr,home
				break
			case 2:
				concatenate/NP=0 {W_Coef}, FvRfCoef_gVr
				concatenate/NP=0 {W_Sigma}, FvRfError_gVr
				movewave FvRfCoef_gVr,home
				movewave FvRfError_gVr,home
				break				
		endswitch

		setdatafolder home
	endfor
end



Function/wave RefineFVTrace(avg70to60,mp,V_half,k,St,En,index)
	variable avg70to60,mp,V_Half,k,index,St,En

	Variable/G gVr

	
	DFREF home=getdatafolderDFR()	
	NewDataFolder/S RefineFV
	variable/G Vr=gVr
	variable/G Foff=avg70to60
	DFREF target=getdatafolderDFR()
	setdatafolder home
	
	if(index!=2)
		wave Vslow=$"VmonSlow"
		wave FV=$stringfromlist(0,Wavelist("Avg_*",";",""))
		duplicate/O/R=[9,28] Vslow, target:VslowTru
		duplicate/O/R=[9,28] FV, target:FVTru
	else
		controlinfo Fwave
		wave FV=$S_value
		controlinfo VsloWave
		wave Vslow=$S_value
		duplicate/O/R=[St,En] Vslow, target:VslowTru
		duplicate/O/R=[St,En] FV, target:FVTru
	endif
	
	make/O/n=(4,2) IniGuess
	
	IniGuess[0][0]=avg70to60
	IniGuess[1][0]=mp
	IniGuess[2][0]=V_half
	IniGuess[3][0]=k	
	IniGuess[][3]=IniGuess[p][0]
	movewave iniGuess, target
	

		
	setdatafolder target
	FuncFit/NTHR=1 FluoVoltage,IniGuess[][0], FVTru /X=VslowTru/D 
		
	string FitName="fit_"+"FVTru"
	wave FitResult=$FitName
	
	Return FitResult
	
end

Function/wave RefineFVNew()  //17.10.2013 for the delay protocol

	Variable/G gVr

	
	DFREF home=getdatafolderDFR()	
	
	wave Vslow=$"Vslow_Spot0"
	wave FV=$"Ratio_Spot0"
	
	//**Find the mp and 
	CurveFit/Q/NTHR=1 line  FV[53,58] /X=Vslow	
	wave W_Coef 
	variable Fo=mean(FV,pnt2x(FV,0),pnt2x(FV,37))
	NewDataFolder/S RefineFV
	variable/G Vr=(Fo-1*W_Coef[0])/W_Coef[1]
	variable Foff=Fo
	Variable mp=W_coef[1]	
	DFREF target=getdatafolderDFR()
	setdatafolder home


	variable i=0
	do
		i+=1
	while(Vslow[i]<-0.067)
	
	duplicate/O/R=[i,DimSize(Vslow,0)] Vslow, target:VslowTru
	duplicate/O/R=[i,DimSize(FV,0)] FV, target:FVTru
	
	variable Fhalf=Fo+((wavemax(FV)-Fo)/2)
	i=0
	do
		i=i+1
	while(FV[i]<Fhalf)
	variable Vhalf =Vslow[i-1]+((Fhalf-FV[i-1])/(FV[i]-FV[i-1]/Vslow[i]-Vslow[i-1]))
	
	CurveFit/NTHR=0 Sigmoid  FV[35,48] /X=VSlow /D
	wave w_coef

//	variable Vhalf=W_Coef[2]
	variable k=W_Coef[3]
	
	make/O/n=(4,2) IniGuess
	
//	IniGuess[0][0]=0
	IniGuess[0][0]=abs(mp)
	IniGuess[1][0]=Vr
	IniGuess[2][0]=Vhalf
	IniGuess[3][0]=k	
	IniGuess[][3]=IniGuess[p][0]
	movewave iniGuess, target
	

		
	setdatafolder target
	
	FuncFit/NTHR=1 FluoVoltage2,IniGuess[][0], FVTru[0,25] /X=VslowTru/D 
		
	string FitName="fit_"+"FVTru"
	wave FitResult=$FitName
	
	display FVTru vs VslowTru 
	appendtograph FitResult
	
	Return FitResult
	
end

Function/wave RefineFVNew2()  //16.02.2015 - Carlos - Copied version of RefineFVNew() to play with the fitting ranges

	Variable/G gVr

	
	DFREF home=getdatafolderDFR()	
	
	wave Vslow=$"Vslow_Spot0"
	wave FV=$"Ratio_Spot0"
	
	//**Find the mp and 
	CurveFit/Q/NTHR=1 line  FV[55,63] /X=Vslow	
	wave W_Coef 
	variable Fo=mean(FV,pnt2x(FV,0),pnt2x(FV,40))
	NewDataFolder/S RefineFV
	variable/G Vr=(Fo-1*W_Coef[0])/W_Coef[1]
	variable Foff=Fo
	Variable mp=W_coef[1]	
	DFREF target=getdatafolderDFR()
	setdatafolder home


	variable i=0
	do
		i+=1
	while(Vslow[i]<-0.067)
	
	duplicate/O/R=[i,DimSize(Vslow,0)] Vslow, target:VslowTru
	duplicate/O/R=[i,DimSize(FV,0)] FV, target:FVTru
	
	variable Fhalf=Fo+((wavemax(FV)-Fo)/2)
	i=0
	do
		i=i+1
	while(FV[i]<Fhalf)
	variable Vhalf =Vslow[i-1]+((Fhalf-FV[i-1])/(FV[i]-FV[i-1]/Vslow[i]-Vslow[i-1]))
	
	CurveFit/NTHR=0 Sigmoid  FV[48,53] /X=VSlow /D
	wave w_coef

//	variable Vhalf=W_Coef[2]
	variable k=W_Coef[3]
	
	make/O/n=(4,2) IniGuess
	
//	IniGuess[0][0]=0
	IniGuess[0][0]=abs(mp)
	IniGuess[1][0]=Vr
	IniGuess[2][0]=Vhalf
	IniGuess[3][0]=k	
	IniGuess[][3]=IniGuess[p][0]
	movewave iniGuess, target
	

		
	setdatafolder target
	
	FuncFit/NTHR=1 FluoVoltage2,IniGuess[][0], FVTru[0,25] /X=VslowTru/D 
		
	string FitName="fit_"+"FVTru"
	wave FitResult=$FitName
	
	display FVTru vs VslowTru 
	appendtograph FitResult
	
	Return FitResult
	
end

Function/wave RefineFV_FixVr()  //04.02.2014 for the delay protocol
//As title, this fitting based on a fixed value of reversal potential Vr
	
	DFREF home=getdatafolderDFR()	
	
	wave Vslow=$"Vslow_Spot0"
	wave FV=$"Ratio_Spot0"
	
	//**Find the mp and
/////////////////////////////////////////////////// change the range //////////////////////////////////////////////	 

	CurveFit/Q/NTHR=1 line  FV[57,61] /X=Vslow    // Here it calculates the Gmax_line  
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	wave W_Coef 
	variable Fo=mean(FV,pnt2x(FV,0),pnt2x(FV,35)) // 29.01.2015 - Carlos
	NewDataFolder/S RefineFV_Vr
	
/////////////////////////////////////////////////////////reversal potential///////////////////////////////////////////////////////		
	variable/G Vr=      0.0656
	//variable/G Vr=0.0656 // reversal potential should be changed here
// 29.01.2015 - Carlos: The following lines were written by TzuLun to get the Vr value from the
// one calculated with the iVr() function. But for some reason, the fitting was not working any longer. So,
// I brought back the first code. And now you have to enter that value manually. TzuLun value is 0.0656
//     DFREF work=GetDataFolderDFR()
//	setdatafolder root:

//	Variable/G Vr                           
//	if(Vr==0)
//		DoAlert 0,"Idiot, there is no Vr found in the root"
//		killvariables Vr
//		return NaN
//	endif
//    SetDataFolder work 
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	variable Foff=Fo
	Variable mp=W_coef[1]	
	DFREF target=getdatafolderDFR()
	setdatafolder home


	variable i=0
	do
		i+=1
	while(Vslow[i]<-0.067)
	
//	duplicate/O/R=[i-1,DimSize(Vslow,0)] Vslow, target:VslowTru
//	duplicate/O/R=[i-1,DimSize(FV,0)] FV, target:FVTru
	duplicate Vslow, target:Vslow
	duplicate FV, target:FV
	
	variable Fhalf=Fo+((wavemax(FV)-Fo)/2)
	i=0
	do
		i=i+1
	while(FV[i]<Fhalf)
	variable Vhalf =Vslow[i-1]+((Fhalf-FV[i-1])/(FV[i]-FV[i-1]/Vslow[i]-Vslow[i-1]))
	
//	CurveFit/Q/NTHR=0 Sigmoid  FV[35,48] /X=VSlow /D
//	CurveFit/Q/NTHR=0 Sigmoid  FV[0,29] /X=VSlow /D // 29.01.2015 - Carlos
      CurveFit/Q/NTHR=0 Sigmoid  FV[35,57] /X=VSlow /D
	wave w_coef

//	variable Vhalf=W_Coef[2]
	variable k=W_Coef[3]
	
	make/O/n=(4,2) IniGuess
	
	IniGuess[0][0]=Fo
	IniGuess[1][0]=abs(mp)
	IniGuess[2][0]=Vhalf
	IniGuess[3][0]=k	
	IniGuess[][1]=IniGuess[p][0]
	movewave iniGuess, target
	

		
	setdatafolder target
	
//	wave/Z FVTru,VslowTru
	
//	FuncFit/Q/NTHR=1 FluoVoltage,IniGuess[][0], FVTru[0,25] /X=VslowTru/D
	FuncFit/Q/NTHR=1 FluoVoltage,IniGuess[][0], FV /X=Vslow/D
	// FluoVoltage has flexible Fo and fixed Vr 
		
	string FitName="fit_"+"Ratio_Spot0"
	wave FitResult=$FitName
	
//	display FVTru vs VslowTru
	display FV vs Vslow  
	appendtograph FitResult
	ModifyGraph zero(left)=3
	
	Return FitResult
	
end


function RefFV2()
	variable index //0:Vr,1:GenVr
	
	
	variable/G Vr
	
	wave F=$"fit_FVTru"
	wave V=$"VSlowTru"
	
	killwaves/Z IniGuess,W_sigma
	
	variable i=-1
	do
		i=i+1
	while(i*DimDelta(F,0)+DimOffset(F,0)<-0.06)
	
		
	variable Frest=mean(F,0,i)			
	variable mp=(Frest-F[DimSize(F,0)-5])/(Vr-pnt2x(F, DimSize(F,0)-5))
				
	make/O/n=(DimSize(F,0)) V2			
	for(i=0;i<Dimsize(F,0);i+=1)
		V2[i]=pnt2x(F,i)
	endfor

	Duplicate/O F,Popen
	Popen=Popen-Frest
	Popen=Popen/(Frest-mp*(Vr-V2))
		
	CurveFit/N/NTHR=0 Sigmoid  Popen /X=V2 /D
	killwaves V2
	wave W_Coef,W_sigma
	variable Vhalf=W_Coef[2]
	variable k=W_Coef[3]

	printf "%g,%g\r", Vhalf,k
		
end

macro Fractionalactivationanalysis() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(614,102,1046,328) as "Fraction activation analysis"
	SetDrawLayer UserBack
	SetDrawEnv linefgc= (0,39168,0),fillfgc= (26112,52224,0)
	DrawRect 219,147,412,211
	SetDrawEnv linefgc= (0,34816,52224),fillfgc= (16384,48896,65280)
	DrawRect 12,147,205,211
	PopupMenu ImonWave,pos={29,9},size={149,21},title="Ion Current",fSize=14
	PopupMenu ImonWave,fStyle=0
	PopupMenu ImonWave,mode=10,popvalue="Imon_Norm",value= #"Wavelist(\"*\",\";\",\"DIMS:1\")"
	PopupMenu VmonWave,pos={219,9},size={187,21},title="Membrane potential   "
	PopupMenu VmonWave,fSize=14
	PopupMenu VmonWave,mode=2,popvalue="Vmon",value= #"wavelist(\"*\",\";\",\"Dims:1\")"
	GroupBox FoPre,pos={220,60},size={193,82},title="Full activation region"
	GroupBox FcPre,pos={12,60},size={193,82},title="Null activation region"
	ValDisplay CsrAo,pos={227,116},size={87,17},title="Point A",fSize=14
	ValDisplay CsrAo,limits={0,0,0},barmisc={0,1000},value=_NUM:0
	ValDisplay CsrBo,disable=2,pos={322,116},size={87,17},title="Point B",fSize=14
	ValDisplay CsrBo,limits={0,0,0},barmisc={0,1000},value=_NUM:0
	ValDisplay CsrAc,disable=2,pos={20,116},size={87,17},title="Point A",fSize=14
	ValDisplay CsrAc,limits={0,0,0},barmisc={0,1000},value=_NUM:0
	ValDisplay CsrBc,disable=2,pos={109,116},size={87,17},title="Point B",fSize=14
	ValDisplay CsrBc,limits={0,0,0},barmisc={0,1000},value=_NUM:0
	Button GetABso,pos={230,83},size={109,24},proc=GetABco,title="Set points"
	Button GetABso,fSize=14
	Button GetABsc,pos={55,83},size={109,24},proc=GetABcc,title="Set points"
	Button GetABsc,fSize=14
	Button DoActFrcAnl,pos={14,163},size={190,34},proc=DoActivFracFit,title="Fit activation fraction trace ( I )"
	Button DoActFrcAnl,fSize=14
	PopupMenu Fwave,pos={15,37},size={152,21},title="fluorescence",fSize=14,fStyle=0
	PopupMenu Fwave,mode=3,popvalue="9_1_Avg",value= #"Wavelist(\"*\",\";\",\"DIMS:1\")"
	PopupMenu VsloWave,pos={221,35},size={209,21},title="Vm for fluorescence   "
	PopupMenu VsloWave,fSize=14
	PopupMenu VsloWave,mode=6,popvalue="VmonSlow",value= #"wavelist(\"*\",\";\",\"Dims:1\")"
	Button DoActFrcAnl1,pos={221,173},size={190,33},proc=DoFAFit,title="Fit activation fraction trace ( F )"
	Button DoActFrcAnl1,fSize=14
	SetVariable Vstep,pos={243,152},size={146,16},title="Potential step (mV)"
	SetVariable Vstep,value= _NUM:10
	Button CgVr,pos={350,83},size={53,24},proc=CalgVr,title="Cal Vr"
EndMacro

Function GetABco(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up			
			valdisplay csrAo, disable=0,value=#"GetCuro(1)"
			valdisplay csrBo, disable=0,value=#"GetCuro(2)"
			controlinfo csrAo
			variable/G ReSt=V_Value
			controlinfo csrBo
			variable/G ReEn=V_Value
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

function/D GetCurc(S)
	variable S
	
	switch(S)
		case 1:
			variable Ao=pcsr(A)
			return Ao
			break
		case 2:
			variable Bo=pcsr(B)
			return Bo
			break
	endswitch

end

function/D GetCuro(S)
	variable S
	
	switch(S)
		case 1:
			variable Ac=pcsr(A)
			return Ac
			break
		case 2:
			variable Bc=pcsr(B)
			return Bc
			break
	endswitch

end

Function GetABcc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up			
			valdisplay csrAc, disable=0,value=#"GetCurc(1)"
			valdisplay csrBc, disable=0,value=#"GetCurc(2)"
			controlinfo csrAc
			variable/G St=V_Value
			controlinfo csrBc
			variable/G En=V_Value

			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

Function DoActivFracFit(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			controlinfo ImonWave
			string Imon=S_Value
			controlinfo VmonWave
			String Vmon=S_Value			
			ActivCurve($Imon,$Vmon,2)
			// click code here
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

function IVForRamp(Ini,Fin,F_int)
	variable Ini,Fin,F_int

	string ImonName=Wavelist("P*_2_1_Imon",";","")
	string VmonName=Wavelist("P*_2_2_Vmon",";","")
	duplicate $StringFromList(0,ImonName),Imon
	duplicate $StringFromList(0,VmonName),Vmon
	
	variable iniT=pnt2x(Vmon,ini)
	
	DeletePoints/M=0 fin,(DimSize(Imon,0)-fin),Imon
	DeletePoints/M=0 fin,(DimSize(Vmon,0)-fin),Vmon
	DeletePoints/M=0 0,ini,Imon,Vmon
	
	string name="Vmon"
	string wavenote=note(Imon)
	string Rseries=stringbykey("\rRSeries",wavenote)
	variable Rs=str2num(Rseries)*10^6
	Vmon=Vmon-Imon*Rs
	rename Vmon, $name
	rename Imon,$"Imon"
	
	setscale/P x,IniT,0.01,Vmon,Imon		
end

Function DoFAFit(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			cPopenF(2)
			// click code here
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

//***********************************************************************************************//
Window IV() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(1351,257,1627,454)
	ModifyPanel frameStyle=4, frameInset=3
	SetDrawLayer UserBack
	SetDrawEnv fillpat= 0
	SetDrawEnv save
	DrawRect 11,41,263,111
	SetDrawEnv fstyle= 1
	DrawText 46,60,"Define the region for averaging"
	PopupMenu folder,pos={13,11},size={242,21},bodyWidth=111,title="Select the data folder        ",value= #"ListFolder()"
	SetVariable regionA,pos={16,67},size={242,16},title="Cursor A",fSize=12,value= _NUM:xcsr(A),live= 1
	SetVariable regionB,pos={16,88},size={242,16},title="Cursor B",fSize=12,value= _NUM:xcsr(B),live= 1
	SetVariable I_keyword,pos={15,120},size={242,16},title="Keyword of current waves ",fSize=12,value= _STR:""
	SetVariable V_keyword,pos={15,140},size={242,16},title="Keyword of voltage waves",fSize=12,value= _STR:""
	
	Button IV,pos={16,160},size={244,30},proc=EasyIV,title="IV"
EndMacro



Function EasyIV(IV)
	STRING IV
//	string allfolder=ListFolder()
//	variable i
	
	
	ControlInfo Folder
	String FF=S_Value
	ControlInfo RegionA
	Variable rA=V_Value
	ControlInfo RegionB
	Variable rB=V_Value
	ControlInfo I_keyword
	String KeyC=S_Value
	ControlInfo V_keyword
	String KeyV=S_Value  
	print FF,rA,rB,keyC
	
	DFREF home =GetDataFolderDFR()
	
	
	if(stringmatch(FF,"")!=1)
		setdatafolder $FF
	else
	endif
//	for(i=0;i<ItemsInList(allfolder)-3;i+=1)
//		SetDataFolder $stringfromlist(i,allfoder)
		String ALLIwaves = Wavelist(keyC,";","")
		String ALLVwaves= Wavelist(keyV,";","")
		make/O/n=(ItemsInList(allIwaves)) I_Avg
		make/O/n=(ItemsInList(allVwaves)) V_Avg
		variable i	
		
		string wavenote,Rseries,name
		variable Rs
		
		for(i=0; i<ItemsInList(allIwaves);i+=1)		
			I_Avg[i] =  mean($StringFromList(i,ALLIwaves,";"),rA,rB)
			
			wave Imon=$StringFromList(i,ALLIWaves,";")
			wavenote=note(Imon)
			Rseries=stringbykey("\rRsValue",wavenote)
			Rs=str2num(Rseries)*10^6
			if(Rs==0)
				Rs=str2num(stringbykey("\rRseries",wavenote))*10^6
			endif
			wave Vmon=$StringFromList(i,ALLVwaves,";")
			make/O/n=(DimSize(Vmon,0)) TempVmon
			TempVmon=Vmon-Imon*Rs
			Setscale/P x,0,deltax(Vmon),TempVmon			
			V_Avg[i] = mean(TempVmon,rA,rB)
			name="Vmon"+num2str(i)
//			rename TempVmon, $name
			killwaves TempVmon			
		endfor
//	ivr()
//Carlos
iVr()
duplicate/O I_avg, $FF
SetScale/P x, -50, 5, $FF
note $FF, "This has not been corrected for Rs"
duplicate/O I_avg,$FF+"_I"
duplicate/O V_avg,$FF+"_V"


SetDataFolder home



End
//*************************************************************************************//

Function CalgVr(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			variable/G gVr
			if(gVr!=0)
			
			else
				variable/G St
				variable/G En
				controlinfo VmonWave
				wave Vmon=$S_Value
				controlinfo ImonWave
				wave Imon=$S_Value
		
				variable/G ReSt
				variable/G ReEn
	
				killwaves/Z sImon,sVmon,W_Coef
				duplicate/O/R=[ReSt,ReEn] Imon, sImon
				duplicate/O/R=[ReSt,ReEn] Vmon, sVmon

				CurveFit/Q/NTHR=1 line  sImon /X=sVmon
			//	killwaves sImon,sVmon	
				wave W_Coef

				variable Io=mean(Imon,pnt2x(Imon,St),pnt2x(Imon,En))

				variable/G gVr=(Io-1*W_Coef[0])/W_Coef[1]
				print gVr*1000
			endif
			
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

function generateDF(Vr)
	variable Vr

	wave fit_FVTru
	variable EnP=fit_FVTru[numpnts(fit_FVTru)-1]
	variable EnV=pnt2x(fit_FVTru,numpnts(fit_FVTru)-1)
	
	make/n=(DimSize(fit_FVTru,0)) Vgradient
	variable i
	for(i=0;i<DimSize(fit_FVTru,0);i+=1)
		Vgradient[i]=pnt2x(fit_FVTru,i)
	endfor
	
	i=0
	
	do
		i=i+1
	while(Vgradient[i]<-0.06)
	
	variable Fo=mean(fit_FVTru,pnt2x(fit_FVTru,0),pnt2x(fit_FVTru,i))
	variable m=(EnP-Fo)/(EnV-Vr)
	
	make/n=(DimSize(fit_FVTru,0)) DrivingFull
	
	
	for(i=0;i<DimSize(fit_FVTru,0);i+=1)
		DrivingFull[i]=m*(Vgradient[i]-Vr)+Fo
	endfor
	
	wave w=wavecalculatorw(3,fit_FVTru,DrivingFull)
	setscale/P x,Vgradient[0],DimDelta(fit_FVTru,0), DrivingFull
	setscale/P x,Vgradient[0],DimDelta(fit_FVTru,0), w
	
	NewDataFolder New_Activation
	movewave Vgradient, :New_Activation:Vgradient
	movewave DrivingFull, :New_Activation:DrivingFull
	movewave w, :New_Activation:ActVr
	setdatafolder New_Activation
	CurveFit/NTHR=0 Sigmoid  ActVr /D
	wave W_Coef
	print W_Coef[2]
	
end

function CalcVmonSlow()
	wave VmonCor
	
	make/O/n=0 VSlow 
	variable j,k=0
	for(j=0;j<Dimsize(VmonCor,0);j+=0.00504/deltax(VmonCor))
		k=k+1
		Insertpoints/M=0 DimSize(VSlow,0),1,VSlow
		Vslow[k]=VmonCor[j]	
	endfor
	
end

function cActFV(F,gVr,ind)
	wave F
	variable gVr,ind
		
	
		
	DFREF home=getdatafolderdfr()
	
	switch(ind)
		case 0:
			newdatafolder/S FPopen_CaVr
			break
		case 1:
			newdatafolder/S FPopen_gVr
			break
	endswitch
	
	DFREF Target=getdatafolderdfr()			
	setdatafolder home
	
	wave Vo=$"VmonSlow"
	make/O/n=(numpnts(Vo)) Vslow
	wave V=$"Vslow" 
	variable i
	
	for(i=0;i<numpnts(Vo);i+=1)
		V[i]=mean(Vo,pnt2x(Vo,i),pnt2x(Vo,i+1))
	endfor
	V=V-0.017	
	variable Frest=mean(F,1,8)
	variable mp=(Frest-F[28])/(gVr-V[28])
	duplicate/O/R=[9,28] V, VslowTru
	duplicate/O/R=[9,28] F, FVTru
	setscale/P x,VSlowTru[0],0.005,FVTru
	

				
	movewave VslowTru, target
	movewave FVTru,target
	setdatafolder Target
	Variable/G Vr=gVr
	
	wave fit_FV=NewRefineFVTr(FVTru,VslowTru,Vr,FRest,mp,ind)
	
	
	
	Differentiate fit_FV/D=d_fit
	
	i=0
	do
		i=i+1
	while(d_fit[i+1]*d_fit[i]>0 && i<dimsize(d_fit,0))
	
	variable/G Xv=pnt2x(d_fit,i)
	Frest=mean(Fit_FV,-0.08,-0.07)
	mp=(Fit_FV[x2pnt(Fit_FV,0)]-FRest)/(0-Vr)
	
//	mp=(Fit_FV[i]-Frest)/(pnt2x(Fit_FV,Xv)-Vr)	
	
	make/O/n=(numpnts(Fit_FV)) Cor_Po
	
	for(i=0;i<numpnts(Fit_FV);i+=1)
		Cor_Po[i]=(fit_FV[i]-Frest)/(mp*(pnt2x(fit_FV,i)-Vr))		
	endfor
	setscale/P x,dimoffset(fit_FV,0),dimdelta(fit_FV,0),Cor_Po
	CurveFit/Q/N/NTHR=0 Sigmoid  Cor_Po[0,x2pnt(Cor_Po,0.01)] /D
//	cFVr(fit_FV)
	
end

function cFVr(F)
	Wave F
	
		
	CurveFit/Q/NTHR=1 line  F[numpnts(F)-10,numpnts(F)]
//	killwaves sImon,sVmon	
	wave W_Coef 
	variable Io=mean(F,pnt2x(F,0),-0.065)
	variable/G FVr=(Io-1*W_Coef[0])/W_Coef[1]
	print FVr*1000
	
end


Function/wave NewRefineFVTr(FV,Vs,Vr,Fo,mp,ind)
	wave FV,Vs
	variable Vr,Fo,mp,ind

	CurveFit/Q/NTHR=1 Sigmoid  FV[2,15] /X=Vs
	wave W_Coef
	
	switch(ind)
		case 0:
			make/O/n=(3,2) IniGuess1
	
			IniGuess1[0][0]=Fo
			IniGuess1[1][0]=mp
			IniGuess1[2][0]=W_Coef[3]
//	variable/G Rk=W_Coef[3]
			variable/G Vh=W_Coef[2]
			IniGuess1[][1]=IniGuess1[p][0]

			
			FuncFit/Q/NTHR=1 FV2,IniGuess1[][0], FV/X=Vs/D 
			break
		case 1:
			make/O/n=(4,2) IniGuess
	
			IniGuess[0][0]=Fo
			IniGuess[1][0]=mp
			IniGuess[2][0]=W_Coef[2]
			IniGuess[3][0]=W_Coef[3]	
			IniGuess[][1]=IniGuess[p][0]

			FuncFit/Q/NTHR=1 FluoVoltage,IniGuess[][0], FV/X=Vs/D 
			break
	endswitch
		
//	IniGuess2[0][0]=IniGuess1[2][0]
//	IniGuess2[1][0]=IniGuess1[3][0]
//	IniGuess2[][1]=IniGuess2[p][0]
//	variable/G GM=IniGuess1[1][0]
//	variable/G F0=IniGuess1[0][0]
//	
//	FuncFit/NTHR=1 FV3,IniGuess2[][0], FV /X=Vs/D 
		
	string FitName="fit_"+"FVTru"
	wave FitResult=$FitName
	
	ReSizeFit()
	
	Return FitResult
	
end

Function FV2(w,V) : FitFunc
	Wave w
	Variable V
	
//	NVAR Vr

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(V) = m*(V-Vr)/1+exp((Vh-V)/k)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ V
	//CurveFitDialog/ Coefficients 4
	//CurveFitDialog/ w[0] = Fo
	//CurveFitDialog/ w[1] = m
	//CurveFitDialog/ w[2] = Vr
	//CurveFitDialog/ w[3] = Vh
	//CurveFitDialog/ w[4] = k
	variable/G Vr
	variable/G Vh
	variable/G Rk

	return w[0]+((w[1]*(Vr-V))/(1+exp((Vh-V)/w[2])))
End

Function FV3(w,V) : FitFunc
	Wave w
	Variable V
	
//	NVAR Vr

	//CurveFitDialog/ These comments were created by the Curve Fitting dialog. Altering them will
	//CurveFitDialog/ make the function less convenient to work with in the Curve Fitting dialog.
	//CurveFitDialog/ Equation:
	//CurveFitDialog/ f(V) = m*(V-Vr)/1+exp((Vh-V)/k)
	//CurveFitDialog/ End of Equation
	//CurveFitDialog/ Independent Variables 1
	//CurveFitDialog/ V
	//CurveFitDialog/ Coefficients 4
	//CurveFitDialog/ w[0] = Fo
	//CurveFitDialog/ w[1] = m
	//CurveFitDialog/ w[2] = Vr
	//CurveFitDialog/ w[3] = Vh
	//CurveFitDialog/ w[4] = k
	variable/G GM
	variable/G F0
	variable/G Vr

	return F0+((GM*(Vr-V))/(1+exp((w[0]-V)/w[1])))
End


function ReSizeFit()
	wave FVTru,VslowTru,fit_FVTru
	
	
	variable n=numpnts(fit_FVTru)
	
	
	variable delta=DimDelta(fit_FVTru,0)
	variable i,testO,test
	
	duplicate fit_FVTru, fit2
	setscale/P x,DimOffset(fit_FVTru,0),delta,fit2	
	make/O/n=(numpnts(FVTru)) Rsm
	for(i=0;i<numpnts(FVTru);i+=1)
		Rsm[i]=fit2[x2pnt(fit2,VslowTru[i])]
	endfor
	wave So=wavecalculatorw(1,Rsm,FVTru)
	test=matrixdot(So,So)
	killwaves So
	

	do
		testO=test
		Delta=Delta+0.00001
		setscale/P x,DimOffset(fit_FVTru,0),delta,fit2	
		make/O/n=(numpnts(FVTru)) Rsm
		for(i=0;i<numpnts(FVTru);i+=1)
			Rsm[i]=fit2[x2pnt(fit2,VslowTru[i])]
		endfor
		duplicate/R=[12,18] Rsm,RsmTru
		duplicate/R=[12,18] FVTru,FVTruTru
		wave So=wavecalculatorw(1,RsmTru,FVTruTru)
		test=matrixdot(So,So)
		killwaves So
		killwaves FVTruTru,RsmTru,Rsm		
	while(test<testO)

//		duplicate/O fit_FVTru, fit2
		setscale/P x,DimOffset(fit_FVTru,0),delta-0.00001,fit2
		duplicate/O fit2,fit_FVTru
		killwaves fit2	

	
end

function FitFVAll(ind)
	variable ind
	string AF=ListFolder()
	variable i,j
	DFREF home=getDataFolderdfr()
	for(i=0;i<ItemsInList(AF)-2;i+=1)
		setdatafolder $stringfromlist(i,AF)		
		wave F=$stringfromlist(0,wavelist("Avg_*",";",""))
		if(stringmatch(NameOfWave(F),"Avg_S")==1)
			wave F=$stringfromlist(1,wavelist("Avg_*",";",""))
		endif
		switch(ind)
			case 0:
				if(DataFolderexists("FPopen_CaVr")==1)
					killdatafolder FPopen_CaVr
				endif
				break
			case 1:
				if(DataFolderexists("FPopen_gVr")==1)
					killdatafolder FPopen_gVr
				endif
				break
			endswitch		
			cActFV(F,0.04,ind)
			setdatafolder home
	endfor
	
end

function autoGo()
	variable i
	
	FitFVAll(0)
	FitFVAll(1)
	DispFV2(0)
	TracesliderFVfit()
	DispCorPo()
//	DispFV2(1)
//	TracesliderFVfit()
//	make/n=(i,2) GetIndex
end


function FVStep()

	string AN=wavelist("TL*",";","")
	
	variable i
	string NewName
	
	for(i=0;i<ItemsInList(AN);i+=1)
		wave w=$stringfromlist(i,AN)
		wave Rest=AvgFrame3D(1,4,w,"Rest")
		wave Dep=AvgFrame3D(6,9,w,"Dep")
		wave w2=wavecalculatorW(1,Dep,Rest)
		NewName="DF_"+num2str(-70+i*5)
		rename w2, $NewName
		killwaves Rest,Dep
	endfor
	
	
end


Function AssembleAFV()  // Desing for delay ramp depolarization protocol 
	string w1=wavelist("CD*1.tif",";","")	
	string w2=wavelist("CD*2.tif",";","")
	string ROIw=wavelist("Square9_*",";","")
	string Vw=wavelist("VmonSlow*",";","")
	
	variable Rest1,Rest2,V_Rest
	string NewFName,NewVName,NewRName
	variable i,j
	for(j=0;j<ItemsInList(ROIw);j+=2)
			wave Fw=$stringfromlist(0,w1)
			wave Nw1=NewPlotROIZ(StringFromList(j,ROIw),1,1,NameOfWave(Fw))			
			wave Sw=$stringfromlist(0,w2)
			wave Nw2=NewPlotROIZ(StringFromList(j+1,ROIw),1,1,NameOfWave(Sw))
			
//////////////////////////////////////////////////////////////////////////Warning//////////////////////////////////////////////////////////////////////////////////////////////
						
//			deletepoints Numpnts(Nw1)-10,25,Nw1,Nw2 //***********Depends***********//
						
//////////////////////////////////////////////////////////////////////////Warning//////////////////////////////////////////////////////////////////////////////////////////////
			
//			deletepoints 0,1,Nw1,Nw2
			
//////////////////////////////////////////////////////////////////////////Warning//////////////////////////////////////////////////////////////////////////////////////////////

			Rest1=mean(Nw1,pnt2x(Nw1,0),pnt2x(Nw1,8))
			Rest2=mean(Nw2,pnt2x(Nw2,0),pnt2x(Nw2,8))

//////////////////////////////////////////////////////////////////////////Warning//////////////////////////////////////////////////////////////////////////////////////////////
			if(Rest1>=Rest2)
				Nw2=Nw2*(Rest1/Rest2)
			else
				Nw1=Nw1*(Rest2/Rest1)
			endif
			NewFName="Avg_Spot"+num2str(j)
			duplicate Nw1, $NewFName
			wave CombineWave=$NewFName
			concatenate/NP=0 {Nw2}, CombineWave
			wave Vw1=$StringFromList(0,Vw)
			wave Vw2=$StringFromList(1,Vw)
//			deletepoints 25,10,Vw1,Vw2
/////////////////////////////////////////////////////////// Re-do will decrease points of VmonSlow permeantly//////////////
//			deletepoints 0,1,Vw1,Vw2			
			NewVName="VSlow_Spot"+num2str(j)
			duplicate Vw1, $NewVName
			wave Vwave=$NewVName
			concatenate/NP=0 {Vw2}, Vwave
			Sort VWave,VWave,CombineWave				
			i=0
			do
				i=i+1
			while(VWave[i]<-0.064)
			V_Rest=mean(Combinewave,0,i-1)
			duplicate CombineWave, RatioWave
			RatioWave=(RatioWave-V_Rest)/V_Rest
			NewRName="Ratio_Spot"+num2str(j)
			Rename RatioWave, $NewRName
	endfor

end

Function AssembleAllFV()
	string aF=ListFolders("*")
	wave/Z BGROI
	if(waveexists(BGROI)!=1)
		return 0
	endif
	DFREF home=GetDataFolderDFR()
	variable i
	for(i=0;i<ItemsInList(aF);i+=1)
		wave/Z BGROI
		duplicate BGROI, :$StringFromList(i,aF):BGROI
		setdatafolder $StringFromList(i,aF)
		AssembleAFV()
		SetDataFolder home
	endfor
end

getfo



Function FindSpotsROI()
	string aF=ListFolders("*")
	DFREF home=GetDataFolderDFR()
	setdatafolder Root:
	variable/G SpotN
	setdatafolder home
	string SpotROI,SquareROI,NewFolderName
	
	variable i,j
	for(i=1;i<=SpotN;i+=2)
		NewFolderName = "Spot_"+num2str(ceil(i/2))
		NewDataFolder/S $NewFolderName
		DFREF Dest=GetDataFolderDFR()
		SetDataFolder home
		SquareROI="Square9_"+num2str(i)
		for(j=0;j<ItemsInList(aF);j+=1)
			SetDataFolder $StringFromList(j,aF)
			wave/Z Sroi=$SquareROI
			if( waveexists(Sroi) !=0 )			
				wave ImgN=$StringFromList(0,wavelist("CD*_1.tif",";",""))
				duplicate ImgN, Dest:$StringFromList(0,wavelist("CD*_1.tif",";",""))
				wave Vmon = $"VmonSlow_1"
				duplicate Vmon, Dest:$NameOfWave(Vmon)
				SpotROI="Spot"+num2str(i)
				wave Proi=$SpotROI
				duplicate Proi, Dest:$NameOfWave(Proi)
				duplicate Sroi, Dest:$NameOfWave(Sroi)	
				SetDataFolder home
				break
			endif
			SetDataFolder home						
		endfor	
	endfor

	for(i=2;i<=SpotN;i+=2)
		NewFolderName = "Spot_"+num2str(i/2)
		SetDataFolder $NewFolderName
		DFREF Dest=GetDataFolderDFR()
		SetDataFolder home
		SquareROI="Square9_"+num2str(i)
		for(j=0;j<ItemsInList(aF)-1;j+=1)
			SetDataFolder $StringFromList(j,aF)
			wave/Z Sroi=$SquareROI
			if( waveexists(Sroi) !=0 )			
				wave ImgN=$StringFromList(0,wavelist("CD*_2.tif",";",""))
				duplicate ImgN, Dest:$StringFromList(0,wavelist("CD*_2.tif",";",""))
				wave Vmon = $"VmonSlow_2"
				duplicate Vmon, Dest:$NameOfWave(Vmon)
				SpotROI="Spot"+num2str(i)
				wave Proi=$SpotROI
				duplicate Proi, Dest:$NameOfWave(Proi)
				duplicate Sroi, Dest:$NameOfWave(Sroi)	
				SetDataFolder home
				break
			endif
			SetDataFolder home						
		endfor	
	endfor
	
	
	
End

Function FindSpotsROITemp() //Because the calculation of VmonSlow is wrong, in this procedure it goes to patchmaster folder to get the correct VmonSlow
	string aF=ListFolder()
	DFREF home=GetDataFolderDFR()
	setdatafolder Root:
	variable/G SpotN
	setdatafolder home
	string SpotROI,SquareROI,NewFolderName,FolderName
	
	variable i,j
	for(i=1;i<=SpotN;i+=2)
		NewFolderName = "Spot_"+num2str(ceil(i/2))
		NewDataFolder/S $NewFolderName
		DFREF Dest=GetDataFolderDFR()
		SetDataFolder home
		SquareROI="Square9_"+num2str(i)
		for(j=0;j<ItemsInList(aF)-1;j+=1)
			SetDataFolder $StringFromList(j,aF)
			wave/Z Sroi=$SquareROI
			if( waveexists(Sroi) !=0 )			
				wave ImgN=$StringFromList(0,wavelist("TL*_1.tif",";",""))
				duplicate ImgN, Dest:$StringFromList(0,wavelist("TL*_1.tif",";",""))
//				wave Vmon = $"VmonSlow_1"
//				duplicate Vmon, Dest:$NameOfWave(Vmon)
				SpotROI="Spot"+num2str(i)
				wave Proi=$SpotROI
				duplicate Proi, Dest:$NameOfWave(Proi)
				duplicate Sroi, Dest:$NameOfWave(Sroi)	
				
				sprintf FolderName,"Root:PatchClamp:L2:%s","Section_"+num2str(j)
				setdatafolder $FolderName 

				duplicate/O $StringFromList(0,WaveList("VmonSlow_*",";","")), Dest:$StringFromList(0,WaveList("VmonSlow_*",";",""))
				
				SetDataFolder home
				break
			endif
			SetDataFolder home						
		endfor	
	endfor

	for(i=2;i<=SpotN;i+=2)
		NewFolderName = "Spot_"+num2str(i/2)
		SetDataFolder $NewFolderName
		DFREF Dest=GetDataFolderDFR()
		SetDataFolder home
		SquareROI="Square9_"+num2str(i)
		for(j=0;j<ItemsInList(aF)-1;j+=1)
			SetDataFolder $StringFromList(j,aF)
			wave/Z Sroi=$SquareROI
			if( waveexists(Sroi) !=0 )			
				wave ImgN=$StringFromList(0,wavelist("TL*_2.tif",";",""))
				duplicate ImgN, Dest:$StringFromList(0,wavelist("TL*_2.tif",";",""))
//				wave Vmon = $"VmonSlow_2"
//				duplicate Vmon, Dest:$NameOfWave(Vmon)
				SpotROI="Spot"+num2str(i)
				wave Proi=$SpotROI
				duplicate Proi, Dest:$NameOfWave(Proi)
				duplicate Sroi, Dest:$NameOfWave(Sroi)
				
				sprintf FolderName,"Root:PatchClamp:L2:%s","Section_"+num2str(j)
				setdatafolder $FolderName 

				duplicate/O $StringFromList(1,WaveList("VmonSlow_*",";","")), Dest:$StringFromList(1,WaveList("VmonSlow_*",";",""))
									
				SetDataFolder home
				break
			endif
			SetDataFolder home						
		endfor	
	endfor
	
	
	
End

Function/Wave NormalizedFitFV(FitFV)



	wave FitFV
	
	variable Rmax=WaveMax(FitFV)
	variable Ro=mean(FitFV,pnt2x(FitFV,0),pnt2x(FitFV,9))
	make/n=(DimSize(FitFV,0)) Norm_FitFV
	Norm_FitFV=Rmax*((FitFV-Ro)/(Rmax-Ro))
	setscale/P x,DimOffset(FitFV,0),DimDelta(FitFV,0),Norm_FitFV
	
	
		
	wave IniGuess
	variable GmO=IniGuess[1][0]
	
	make/n=4 Guess
	variable/G Vr
	Guess[0]=IniGuess[1][0]
	Guess[1]=Vr
	Guess[2]=IniGuess[2][0]
	Guess[3]=IniGuess[3][0]
	
	Funcfit/Q FluoVoltage2, Guess[] Norm_FitFV
	variable Gm=Guess[0]
	variable VrN=Guess[1]
	print VrN
	
	killwaves Guess
	
	
	variable i
	Duplicate Norm_FitFV,Sigmoid_NormFitFV
	make/n=(DimSize(Norm_FitFV,0)) Gmax_Line
	for(i=0;i<DimSize(Norm_FitFV,0);i+=1)	
		Gmax_Line[i]=Gm*(VrN-pnt2x(Norm_FitFV,i))//*GmO*(Vr-pnt2x(Norm_FitFV,i))
	endfor	
//	for(i=0;i<DimSize(Norm_FitFV,0);i+=1)	
//		Sigmoid_NormFitFV[i]=(Norm_FitFV[i]/(Gm*(VrN-pnt2x(Norm_FitFV,i))))//*GmO*(Vr-pnt2x(Norm_FitFV,i))
//	endfor
	Sigmoid_NormFitFV=Sigmoid_NormFitFV/Gmax_Line
	setscale/P x,DimOffset(FitFV,0),DimDelta(FitFV,0),Sigmoid_NormFitFV,Gmax_Line
		
	CurveFit/Q/N/NTHR=0 Sigmoid  Sigmoid_NormFitFV[x2pnt(Gmax_Line,-0.07),x2pnt(Gmax_Line,0.064)]/D
	wave w_coef
//	make/n=(DimSize(FitFV,0)) Fmax
//	for(i=0;i<DimSize(Norm_FitFV,0);i+=1)	
//		Fmax[i]=Gmo*(Vr-pnt2x(Norm_FitFV,i))
//	endfor
//	setscale/P x,DimOffset(FitFV,0),DimDelta(FitFV,0),Fmax
//	Norm_FitFV_Temp=Fmax*Norm_FitFV_Temp	
//	variable RmaxN=wavemax(Norm_FitFV_Temp)
////	Norm_FitFV_Temp=Norm_FitFV_Temp*(Rmax/RmaxN)
	
	return w_coef

	

end